<?php

namespace Database\Seeders\Update;

use App\Models\Admin\TransactionSetting;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TransactionSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if(!TransactionSetting::where('slug','reload_card')->exists()){
            $data = [
                        [
                            'admin_id'          => 1,
                            'slug'              => "reload_card",
                            'title'             => "Card Reload Charges",
                            'fixed_charge'      => 2,
                            'percent_charge'    => 1,
                            'min_limit'         => 100,
                            'max_limit'         => 50000,
                            'monthly_limit'     => 0,
                            'daily_limit'       => 0,
                        ],

            ];
        TransactionSetting::insert($data);
        }
    }
}
