<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\SiteSections;
use Illuminate\Database\Seeder;
use App\Constants\SiteSectionConst;
use Illuminate\Support\Str;

class SiteSectionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $site_sections = array(
            array('key' => 'site_cookie','value' => '{"status":true,"link":"page\\/privacy-policy","desc":"<p><span style=\\"color:hsl(0,0%,0%);\\">We may use cookies or any other tracking technologies when you visit our website, including any other media form, mobile website, or mobile application related or connected to help customize the Site and improve your experience.<\\/span><\\/p><p>&nbsp;<\\/p>"}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => NULL),
            array('key' => 'home-banner','value' => '{"images":{"banner_image":"3770d1fc-37bf-4a7a-9e5d-170883df5df9.webp"},"language":{"en":{"heading":"Unveiling the Virtual Credit Card Experience","sub_heading":"The payment needs of major online giants such as AliExpress, Netflix, Facebook-Google Advertising, Amazon, and various other shopping platforms.","button_name":"Apply Virtual Card","button_link":"contact"},"es":{"heading":"Presentando la experiencia de la tarjeta de cr\\u00e9dito virtual","sub_heading":"Las necesidades de pago de los principales gigantes en l\\u00ednea como AliExpress, Netflix, Facebook-Google Advertising, Amazon y varias otras plataformas de compras.","button_name":"Aplicar Tarjeta Virtual","button_link":"contact"},"ar":{"heading":"\\u0627\\u0644\\u0643\\u0634\\u0641 \\u0639\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629","sub_heading":"\\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0644\\u0643\\u0628\\u0627\\u0631 \\u0639\\u0645\\u0627\\u0644\\u0642\\u0629 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0645\\u062b\\u0644 AliExpress \\u0648Netflix \\u0648Facebook-Google Advertising \\u0648Amazon \\u0648\\u0627\\u0644\\u0639\\u062f\\u064a\\u062f \\u0645\\u0646 \\u0645\\u0646\\u0635\\u0627\\u062a \\u0627\\u0644\\u062a\\u0633\\u0648\\u0642 \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649.","button_name":"\\u062a\\u0637\\u0628\\u064a\\u0642 \\u0627\\u0644\\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629","button_link":"contact"}}}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => '2023-11-06 12:08:32'),
            array('key' => 'about-section','value' => '{"images":{"banner_image":"88c1be66-6038-438e-8b7c-64a6b3356a71.webp","first_section_image":"afbb5b41-2bed-47c9-a82a-ef16751d8f90.webp","second_section_image":"e3261cd8-8861-42cd-9df4-152bdc126b57.webp","image":"98d8b2de-c267-484a-8316-b5d518570c10.webp"},"language":{"en":{"section_title":"About Us","heading":"Empowering the Future of Online Transactions","sub_heading":"we are at the forefront of revolutionizing the way people navigate the digital financial landscape. Our mission is clear: to provide users and entrepreneurs with a secure, efficient, and user-friendly platform for conducting online transactions through virtual credit cards."},"es":{"section_title":"Sobre nosotras","heading":"Potenciando el futuro de las transacciones en l\\u00ednea","sub_heading":"Estamos a la vanguardia de revolucionar la forma en que las personas navegan por el panorama financiero digital. Nuestra misi\\u00f3n es clara: brindar a usuarios y emprendedores una plataforma segura, eficiente y amigable para realizar transacciones en l\\u00ednea a trav\\u00e9s de tarjetas de cr\\u00e9dito virtuales."},"ar":{"section_title":"\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0639\\u0646\\u0627","heading":"\\u062a\\u0645\\u0643\\u064a\\u0646 \\u0645\\u0633\\u062a\\u0642\\u0628\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a","sub_heading":"\\u0646\\u062d\\u0646 \\u0641\\u064a \\u0637\\u0644\\u064a\\u0639\\u0629 \\u0625\\u062d\\u062f\\u0627\\u062b \\u062b\\u0648\\u0631\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u062a\\u0646\\u0642\\u0644 \\u0628\\u0647\\u0627 \\u0627\\u0644\\u0623\\u0634\\u062e\\u0627\\u0635 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0634\\u0647\\u062f \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a. \\u0645\\u0647\\u0645\\u062a\\u0646\\u0627 \\u0648\\u0627\\u0636\\u062d\\u0629: \\u062a\\u0632\\u0648\\u064a\\u062f \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0648\\u0631\\u062c\\u0627\\u0644 \\u0627\\u0644\\u0623\\u0639\\u0645\\u0627\\u0644 \\u0628\\u0645\\u0646\\u0635\\u0629 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u0641\\u0639\\u0627\\u0644\\u0629 \\u0648\\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629."}},"items":{"643eb4e71fe4e":{"language":{"en":{"title":"Our Vision","icon":"fas fa-check"},"es":{"title":"Nuestra visi\\u00f3n","icon":"fas fa-check"},"ar":{"title":"\\u0631\\u0624\\u064a\\u062a\\u0646\\u0627","icon":"fas fa-check"}},"id":"643eb4e71fe4e"},"643eb5ed48d64":{"language":{"en":{"title":"The StripCard Difference","icon":"fas fa-check"},"es":{"title":"La diferencia con StripCard","icon":"transacci\\u00f3n de recibos"},"ar":{"title":"\\u0627\\u0644\\u0641\\u0631\\u0642 StripCard","icon":"fas fa-check"}},"id":"643eb5ed48d64"},"643eb61b0a83f":{"language":{"en":{"title":"Our Commitment","icon":"fas fa-check"},"es":{"title":"Nuestro compromiso","icon":"fas fa-check"},"ar":{"title":"\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0646\\u0627","icon":"fas fa-check"}},"id":"643eb61b0a83f"},"643eb6396376b":{"language":{"en":{"title":"Join Us on this Journey","icon":"fas fa-check"},"es":{"title":"\\u00danete a nosotros en este viaje","icon":"fas fa-check"},"ar":{"title":"\\u0627\\u0646\\u0636\\u0645 \\u0625\\u0644\\u064a\\u0646\\u0627 \\u0641\\u064a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0631\\u062d\\u0644\\u0629","icon":"fas fa-check"}},"id":"643eb6396376b"}}}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => '2023-11-06 12:13:09'),
            array('key' => 'testimonials-section','value' => '{"language":{"en":{"title":"What Our Users Are Saying","sub_heading":"Explore what our satisfied users have to say about their experiences with it."},"es":{"title":"Lo que nuestras usuarias est\\u00e1n diciendo","sub_heading":"Explore lo que nuestros usuarios satisfechos tienen que decir sobre sus experiencias con \\u00e9l."},"ar":{"title":"\\u0645\\u0627 \\u064a\\u0642\\u0648\\u0644\\u0647 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u0648\\u0646\\u0627","sub_heading":"\\u0627\\u0643\\u062a\\u0634\\u0641 \\u0645\\u0627 \\u064a\\u0642\\u0648\\u0644\\u0647 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u0648\\u0646\\u0627 \\u0627\\u0644\\u0631\\u0627\\u0636\\u0648\\u0646 \\u0639\\u0646 \\u062a\\u062c\\u0627\\u0631\\u0628\\u0647\\u0645 \\u0645\\u0639\\u0647."}},"items":{"643820a97ee03":{"language":{"en":{"name":"Sarah Williams","designation":"Marketing Manager","rating":"5","details":"\\u201cStripCard has completely transformed the way we handle online transactions in our company. The security features are top-notch, and the ease of generating virtual cards makes our online purchases hassle-free. I highly recommend StripCard to anyone looking for a secure and convenient online payment solution.\\u201d"},"es":{"name":"Sara Williams","designation":"Gerente de Mercadeo","rating":"5","details":"\\u201cStripCard ha transformado completamente la forma en que manejamos las transacciones en l\\u00ednea en nuestra empresa. Las caracter\\u00edsticas de seguridad son de primer nivel y la facilidad para generar tarjetas virtuales hace que nuestras compras en l\\u00ednea sean sencillas. Recomiendo ampliamente StripCard a cualquiera que busque una soluci\\u00f3n de pago en l\\u00ednea segura y conveniente\\u201d."},"ar":{"name":"\\u0633\\u0627\\u0631\\u0629 \\u0648\\u064a\\u0644\\u064a\\u0627\\u0645\\u0632","designation":"\\u0645\\u062f\\u064a\\u0631 \\u062a\\u0633\\u0648\\u064a\\u0642","rating":"5","details":"\\"\\u0644\\u0642\\u062f \\u063a\\u064a\\u0631\\u062a StripCard \\u062a\\u0645\\u0627\\u0645\\u064b\\u0627 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0646\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0628\\u0647\\u0627 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0641\\u064a \\u0634\\u0631\\u0643\\u062a\\u0646\\u0627. \\u062a\\u062a\\u0645\\u064a\\u0632 \\u0645\\u064a\\u0632\\u0627\\u062a \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0628\\u0623\\u0646\\u0647\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u0637\\u0631\\u0627\\u0632 \\u0627\\u0644\\u0623\\u0648\\u0644\\u060c \\u0643\\u0645\\u0627 \\u0623\\u0646 \\u0633\\u0647\\u0648\\u0644\\u0629 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u062a\\u062c\\u0639\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0634\\u0631\\u0627\\u0621 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628. \\u0623\\u0648\\u0635\\u064a \\u0628\\u0634\\u062f\\u0629 \\u0628\\u0640 StripCard \\u0644\\u0623\\u064a \\u0634\\u062e\\u0635 \\u064a\\u0628\\u062d\\u062b \\u0639\\u0646 \\u062d\\u0644 \\u0622\\u0645\\u0646 \\u0648\\u0645\\u0631\\u064a\\u062d \\u0644\\u0644\\u062f\\u0641\\u0639 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a."}},"id":"643820a97ee03","image":"2e7cc167-a7cd-4031-a97c-04ec1db1c445.webp"},"64382127cf532":{"language":{"en":{"name":"John Smith","designation":"Small Business Owner","rating":"4","details":"\\u201cAs a small business owner, StripCard has been a game-changer. It allows me to offer convenient payment options to my clients while generating an extra revenue stream. The one-time-use codes provide peace of mind, knowing that my transactions are secure. StripCard is a win-win for both my clients and my business.\\u201d"},"es":{"name":"John Smith","designation":"Propietario de un peque\\u00f1o negocio","rating":"4","details":"\\u201cComo propietario de una peque\\u00f1a empresa, StripCard ha cambiado las reglas del juego. Me permite ofrecer opciones de pago convenientes a mis clientes y al mismo tiempo generar un flujo de ingresos adicional. Los c\\u00f3digos de un solo uso brindan la tranquilidad de saber que mis transacciones son seguras. StripCard es beneficioso tanto para mis clientes como para mi negocio\\u201d."},"ar":{"name":"\\u062c\\u0648\\u0646 \\u0633\\u0645\\u064a\\u062b","designation":"\\u0635\\u0627\\u062d\\u0628 \\u0645\\u0634\\u0631\\u0648\\u0639 \\u0635\\u063a\\u064a\\u0631","rating":"4","details":"\\"\\u0628\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0645\\u0627\\u0644\\u0643\\u064b\\u0627 \\u0644\\u0634\\u0631\\u0643\\u0629 \\u0635\\u063a\\u064a\\u0631\\u0629\\u060c \\u0641\\u0642\\u062f \\u063a\\u064a\\u0631\\u062a StripCard \\u0642\\u0648\\u0627\\u0639\\u062f \\u0627\\u0644\\u0644\\u0639\\u0628\\u0629. \\u0641\\u0647\\u0648 \\u064a\\u062a\\u064a\\u062d \\u0644\\u064a \\u062a\\u0642\\u062f\\u064a\\u0645 \\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u062f\\u0641\\u0639 \\u0645\\u0646\\u0627\\u0633\\u0628\\u0629 \\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u064a \\u0645\\u0639 \\u062a\\u0648\\u0644\\u064a\\u062f \\u062a\\u062f\\u0641\\u0642 \\u0625\\u0636\\u0627\\u0641\\u064a \\u0644\\u0644\\u0625\\u064a\\u0631\\u0627\\u062f\\u0627\\u062a. \\u062a\\u0648\\u0641\\u0631 \\u0631\\u0645\\u0648\\u0632 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0644\\u0645\\u0631\\u0629 \\u0648\\u0627\\u062d\\u062f\\u0629 \\u0631\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0628\\u0627\\u0644\\u060c \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0644\\u0645 \\u0623\\u0646 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u064a \\u0622\\u0645\\u0646\\u0629. \\u064a\\u0639\\u062f StripCard \\u0645\\u0631\\u0628\\u062d\\u064b\\u0627 \\u0644\\u0643\\u0644 \\u0645\\u0646 \\u0639\\u0645\\u0644\\u0627\\u0626\\u064a \\u0648\\u0639\\u0645\\u0644\\u064a."}},"id":"64382127cf532","image":"11a9a3a2-3061-4bac-b7ae-ef630df7f563.webp"},"6438252b52033":{"language":{"en":{"name":"Lisa Rodriguez","designation":"Online Shopper","rating":"5","details":"\\u201cShopping online has never been this secure and straightforward. StripCard\\u2019s unique codes make me feel confident about the safety of my transactions. It\\u2019s like having an extra layer of protection. I can\\u2019t imagine going back to using my regular card for online purchases. StripCard has won me over!\\u201d"},"es":{"name":"Lisa Rodriguez","designation":"Comprador en l\\u00ednea","rating":"5","details":"\\u201cComprar online nunca ha sido tan seguro y sencillo. Los c\\u00f3digos \\u00fanicos de StripCard me hacen sentir seguro sobre la seguridad de mis transacciones. Es como tener una capa extra de protecci\\u00f3n. No me imagino volver a utilizar mi tarjeta habitual para compras online. \\u00a1StripCard me ha convencido!\\u201d"},"ar":{"name":"\\u0644\\u064a\\u0632\\u0627 \\u0631\\u0648\\u062f\\u0631\\u064a\\u062c\\u064a\\u0632","designation":"\\u0627\\u0644\\u0634\\u0631\\u0627\\u0621 \\u0639\\u0644\\u0627\\u0646\\u062a\\u0631\\u0646\\u064a\\u062a","rating":"5","details":"\\"\\u0644\\u0645 \\u064a\\u0643\\u0646 \\u0627\\u0644\\u062a\\u0633\\u0648\\u0642 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0628\\u0647\\u0630\\u0647 \\u0627\\u0644\\u062f\\u0631\\u062c\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0648\\u0627\\u0644\\u0628\\u0633\\u0627\\u0637\\u0629 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0631\\u0645\\u0648\\u0632 StripCard \\u0627\\u0644\\u0641\\u0631\\u064a\\u062f\\u0629 \\u062a\\u062c\\u0639\\u0644\\u0646\\u064a \\u0623\\u0634\\u0639\\u0631 \\u0628\\u0627\\u0644\\u062b\\u0642\\u0629 \\u0628\\u0634\\u0623\\u0646 \\u0633\\u0644\\u0627\\u0645\\u0629 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u064a. \\u0625\\u0646\\u0647 \\u0645\\u062b\\u0644 \\u0648\\u062c\\u0648\\u062f \\u0637\\u0628\\u0642\\u0629 \\u0625\\u0636\\u0627\\u0641\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062d\\u0645\\u0627\\u064a\\u0629. \\u0644\\u0627 \\u0623\\u0633\\u062a\\u0637\\u064a\\u0639 \\u0623\\u0646 \\u0623\\u062a\\u062e\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0648\\u062f\\u0629 \\u0625\\u0644\\u0649 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u0637\\u0627\\u0642\\u062a\\u064a \\u0627\\u0644\\u0639\\u0627\\u062f\\u064a\\u0629 \\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0634\\u0631\\u0627\\u0621 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a. \\u0644\\u0642\\u062f \\u0641\\u0627\\u0632 \\u0628\\u064a StripCard!"}},"id":"6438252b52033","image":"e0140d7d-0a56-4201-b99b-27efc561f565.webp"}}}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => '2023-11-06 12:27:48'),
            array('key' => 'contact','value' => '{"language":{"en":{"title":"Contact Us","heading":"Feel Free To Get In Touch With Us","infomation":"We\\u2019d love to hear from you! If you have any questions or need assistance, please don\\u2019t hesitate to get in touch with us using the following contact information:","address":"1234 Main Street City, State 56789 USA","phone":"+1 (123) 456-7890","email":"info@example.com"},"es":{"title":"Contacta con nosotra","heading":"Si\\u00e9ntase libre de ponerse en contacto con nosotras","infomation":"\\u00a1Nos encantar\\u00eda saber de usted! Si tiene alguna pregunta o necesita ayuda, no dude en ponerse en contacto con nosotros utilizando la siguiente informaci\\u00f3n de contacto:","address":"1234 Main Street Ciudad, Estado 56789 EE. UU.","phone":"+1 (123) 456-7890","email":"info@example.com"},"ar":{"title":"\\u0627\\u062a\\u0635\\u0644 \\u0628\\u0646\\u0627","heading":"\\u0644\\u0627 \\u062a\\u062a\\u0631\\u062f\\u062f \\u0641\\u064a \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639\\u0646\\u0627","infomation":"\\u0646\\u062d\\u0646 \\u0646\\u062d\\u0628 \\u0623\\u0646 \\u0646\\u0633\\u0645\\u0639 \\u0645\\u0646\\u0643! \\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0643 \\u0623\\u064a \\u0623\\u0633\\u0626\\u0644\\u0629 \\u0623\\u0648 \\u0643\\u0646\\u062a \\u0628\\u062d\\u0627\\u062c\\u0629 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u0627\\u0639\\u062f\\u0629\\u060c \\u0641\\u0644\\u0627 \\u062a\\u062a\\u0631\\u062f\\u062f \\u0641\\u064a \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644 \\u0628\\u0646\\u0627 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:","address":"1234 \\u0645\\u064a\\u0646 \\u0633\\u062a\\u0631\\u064a\\u062a \\u0633\\u064a\\u062a\\u064a\\u060c \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0629 56789 \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u062d\\u062f\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0631\\u064a\\u0643\\u064a\\u0629","phone":"+1 (123) 456-7890","email":"info@example.com"}}}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => '2023-11-06 12:51:38'),
            array('key' => 'footer-section','value' => '{"language":{"en":{"footer_text":"Copyright \\u00a9 2023 , All Rights Reserved.","details":"Thank you for choosing StripCard as your trusted partner for secure online transactions. We are committed to providing you with a seamless and secure experience."},"es":{"footer_text":"Copyright \\u00a9 2023, Todos los derechos reservados.","details":"Gracias por elegir StripCard como su socio de confianza para transacciones seguras en l\\u00ednea. Estamos comprometidos a brindarle una experiencia fluida y segura."},"ar":{"footer_text":"\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0646\\u0634\\u0631 \\u00a9 2023\\u060c \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0645\\u062d\\u0641\\u0648\\u0638\\u0629.","details":"\\u0646\\u0634\\u0643\\u0631\\u0643 \\u0639\\u0644\\u0649 \\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 StripCard \\u0643\\u0634\\u0631\\u064a\\u0643 \\u0645\\u0648\\u062b\\u0648\\u0642 \\u0628\\u0647 \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0622\\u0645\\u0646\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a. \\u0646\\u062d\\u0646 \\u0645\\u0644\\u062a\\u0632\\u0645\\u0648\\u0646 \\u0628\\u062a\\u0632\\u0648\\u064a\\u062f\\u0643 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0633\\u0644\\u0633\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629."}},"items":{"643ec92bddaae":{"language":{"en":{"name":"Facebook","social_icon":"fab fa-facebook","link":"https:\\/\\/facebook.com\\/"},"es":{"name":"Facebook","social_icon":"fab fa-facebook","link":"https:\\/\\/facebook.com\\/"},"ar":{"name":"\\u0641\\u064a\\u0633\\u0628\\u0648\\u0643","social_icon":"fab fa-facebook","link":"https:\\/\\/facebook.com\\/"}},"id":"643ec92bddaae"},"643ec94c4769c":{"language":{"en":{"name":"Instagram","social_icon":"fab fa-instagram","link":"https:\\/\\/www.instagram.com\\/"},"es":{"name":"Instagram","social_icon":"fab fa-instagram","link":"https:\\/\\/www.instagram.com\\/"},"ar":{"name":"\\u0627\\u0646\\u0633\\u062a\\u063a\\u0631\\u0627\\u0645","social_icon":"fab fa-instagram","link":"https:\\/\\/www.instagram.com\\/"}},"id":"643ec94c4769c"},"643ec96763812":{"language":{"en":{"name":"Twitter","social_icon":"fab fa-twitter","link":"https:\\/\\/twitter.com\\/login"},"es":{"name":"Twitter","social_icon":"fab fa-twitter","link":"https:\\/\\/twitter.com\\/login"},"ar":{"name":"\\u062a\\u0648\\u064a\\u062a\\u0631","social_icon":"fab fa-twitter","link":"https:\\/\\/twitter.com\\/login"}},"id":"643ec96763812"}}}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => '2023-11-06 13:01:31'),
            array('key' => 'our-features','value' => '{"language":{"en":{"heading":"Our Features","sub_heading":"Redefining Online Transactions","details":"Discover the unparalleled features that make StripCard the go-to platform for secure, convenient, and efficient online transactions. With our virtual credit cards, you can seamlessly shop, subscribe, and transact online, all with just a few clicks."},"es":{"heading":"Nuestras caracter\\u00edsticas","sub_heading":"Redefiniendo las transacciones en l\\u00ednea","details":"Descubra las caracter\\u00edsticas incomparables que hacen de StripCard la plataforma ideal para transacciones en l\\u00ednea seguras, convenientes y eficientes. Con nuestras tarjetas de cr\\u00e9dito virtuales, puede comprar, suscribirse y realizar transacciones en l\\u00ednea sin problemas, todo con solo unos pocos clics."},"ar":{"heading":"\\u0645\\u0645\\u064a\\u0632\\u0627\\u062a\\u0646\\u0627","sub_heading":"\\u0625\\u0639\\u0627\\u062f\\u0629 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a","details":"\\u0627\\u0643\\u062a\\u0634\\u0641 \\u0627\\u0644\\u0645\\u064a\\u0632\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0644\\u0627 \\u0645\\u062b\\u064a\\u0644 \\u0644\\u0647\\u0627 \\u0648\\u0627\\u0644\\u062a\\u064a \\u062a\\u062c\\u0639\\u0644 StripCard \\u0645\\u0646\\u0635\\u0629 \\u0627\\u0644\\u0627\\u0646\\u062a\\u0642\\u0627\\u0644 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0631\\u064a\\u062d\\u0629 \\u0648\\u0627\\u0644\\u0641\\u0639\\u0627\\u0644\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a. \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0646\\u0627\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u062a\\u0633\\u0648\\u0642 \\u0648\\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643 \\u0648\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629\\u060c \\u0643\\u0644 \\u0630\\u0644\\u0643 \\u0628\\u0628\\u0636\\u0639 \\u0646\\u0642\\u0631\\u0627\\u062a \\u0641\\u0642\\u0637."}},"items":{"643eb72c2c42f":{"language":{"en":{"title":"Virtual Credit Cards","sub_title":"Say goodbye to the limitations of physical credit cards."},"es":{"title":"Tarjetas de cr\\u00e9dito virtuales","sub_title":"Dile adi\\u00f3s a las limitaciones de las tarjetas de cr\\u00e9dito f\\u00edsicas."},"ar":{"title":"\\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629","sub_title":"\\u0642\\u0644 \\u0648\\u062f\\u0627\\u0639\\u064b\\u0627 \\u0644\\u0644\\u0642\\u064a\\u0648\\u062f \\u0627\\u0644\\u0645\\u0641\\u0631\\u0648\\u0636\\u0629 \\u0639\\u0644\\u0649 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0627\\u062f\\u064a\\u0629."}},"id":"643eb72c2c42f"},"643eb745b1758":{"language":{"en":{"title":"Cutting-Edge Security","sub_title":"We employ state-of-the-art encryption and security protocols to ensure your financial data is protected at all times."},"es":{"title":"Seguridad de vanguardia","sub_title":"Empleamos protocolos de seguridad y cifrado de \\u00faltima generaci\\u00f3n para garantizar que sus datos financieros est\\u00e9n protegidos en todo momento."},"ar":{"title":"\\u0627\\u0644\\u0623\\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0637\\u0648\\u0631","sub_title":"\\u0646\\u062d\\u0646 \\u0646\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0623\\u062d\\u062f\\u062b \\u0628\\u0631\\u0648\\u062a\\u0648\\u0643\\u0648\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u0634\\u0641\\u064a\\u0631 \\u0648\\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0641\\u064a \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u0623\\u0648\\u0642\\u0627\\u062a."}},"id":"643eb745b1758"},"643eb77aa0589":{"language":{"en":{"title":"Transparent Fee Structure","sub_title":"It maintains a straightforward fee structure, ensuring you always know what to expect, with no surprises."},"es":{"title":"Estructura de tarifas transparente","sub_title":"Mantiene una estructura de tarifas sencilla, lo que garantiza que siempre sepa qu\\u00e9 esperar, sin sorpresas."},"ar":{"title":"\\u0647\\u064a\\u0643\\u0644 \\u0631\\u0633\\u0648\\u0645 \\u0634\\u0641\\u0627\\u0641","sub_title":"\\u0625\\u0646\\u0647 \\u064a\\u062d\\u0627\\u0641\\u0638 \\u0639\\u0644\\u0649 \\u0647\\u064a\\u0643\\u0644 \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0628\\u0627\\u0634\\u0631\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0623\\u0646\\u0643 \\u062a\\u0639\\u0631\\u0641 \\u062f\\u0627\\u0626\\u0645\\u064b\\u0627 \\u0645\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u062a\\u0648\\u0642\\u0639\\u0647\\u060c \\u062f\\u0648\\u0646 \\u0623\\u064a \\u0645\\u0641\\u0627\\u062c\\u0622\\u062a."}},"id":"643eb77aa0589"},"643eb794b9daa":{"language":{"en":{"title":"User-Friendly Interface","sub_title":"Our platform boasts an intuitive, user-friendly interface, designed for both beginners and experienced users."},"es":{"title":"Interfaz amigable","sub_title":"Nuestra plataforma cuenta con una interfaz intuitiva y f\\u00e1cil de usar, dise\\u00f1ada tanto para principiantes como para usuarios experimentados."},"ar":{"title":"\\u0648\\u0627\\u062c\\u0647\\u0629 \\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645","sub_title":"\\u062a\\u062a\\u0645\\u064a\\u0632 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 \\u0628\\u0648\\u0627\\u062c\\u0647\\u0629 \\u0628\\u062f\\u064a\\u0647\\u064a\\u0629 \\u0648\\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u060c \\u0645\\u0635\\u0645\\u0645\\u0629 \\u0644\\u0643\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0628\\u062a\\u062f\\u0626\\u064a\\u0646 \\u0648\\u0630\\u0648\\u064a \\u0627\\u0644\\u062e\\u0628\\u0631\\u0629."}},"id":"643eb794b9daa"}}}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => '2023-11-06 12:18:29'),
            array('key' => 'work-section','value' => '{"language":{"en":{"title":"How It is Work","sub_title":"Flow Our Step For Create Your Accounttest"},"es":{"title":"como funciona","sub_title":"Fluya nuestro paso para crear su cuenta."},"ar":{"title":"\\u0643\\u064a\\u0641 \\u064a\\u062a\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644","sub_title":"\\u0627\\u062a\\u0628\\u0639 \\u062e\\u0637\\u0648\\u062a\\u0646\\u0627 \\u0644\\u0625\\u0646\\u0634\\u0627\\u0621 \\u062d\\u0633\\u0627\\u0628\\u0643"}},"items":{"643eb81b49cb8":{"language":{"en":{"name":"Sign Up","icon":"las la-user-circle","details":"Begin by signing up on the StripCard platform. Provide the required information to create your account."},"es":{"name":"Inscribirse","icon":"las la-user-circle","details":"Comience registr\\u00e1ndose en la plataforma StripCard. Proporcione la informaci\\u00f3n requerida para crear su cuenta."},"ar":{"name":"\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643","icon":"las la-user-circle","details":"\\u0627\\u0628\\u062f\\u0623 \\u0628\\u0627\\u0644\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0641\\u064a \\u0645\\u0646\\u0635\\u0629 StripCard. \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0637\\u0644\\u0648\\u0628\\u0629 \\u0644\\u0625\\u0646\\u0634\\u0627\\u0621 \\u062d\\u0633\\u0627\\u0628\\u0643."}},"id":"643eb81b49cb8"},"643eb86734f8f":{"language":{"en":{"name":"Loading Funds","icon":"las la-credit-card","details":"This can be done through various payment methods, ensuring flexibility and convenience."},"es":{"name":"Cargando fondos","icon":"las la-credit-card","details":"Esto se puede hacer a trav\\u00e9s de varios m\\u00e9todos de pago, lo que garantiza flexibilidad y comodidad."},"ar":{"name":"\\u062a\\u062d\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644","icon":"las la-credit-card","details":"\\u0648\\u064a\\u0645\\u0643\\u0646 \\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0630\\u0644\\u0643 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0637\\u0631\\u0642 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0645\\u0631\\u0648\\u0646\\u0629 \\u0648\\u0627\\u0644\\u0631\\u0627\\u062d\\u0629."}},"id":"643eb86734f8f"},"643eb8a0bb232":{"language":{"en":{"name":"Apply Virtual Card","icon":"las la-paper-plane","details":"It mirrors your traditional credit card, allowing you to conduct online transactions securely"},"es":{"name":"Aplicar Tarjeta Virtual","icon":"las la-paper-plane","details":"Refleja su tarjeta de cr\\u00e9dito tradicional, permiti\\u00e9ndole realizar transacciones en l\\u00ednea de forma segura"},"ar":{"name":"\\u062a\\u0637\\u0628\\u064a\\u0642 \\u0627\\u0644\\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629","icon":"las la-paper-plane","details":"\\u0625\\u0646\\u0647\\u0627 \\u062a\\u0639\\u0643\\u0633 \\u0628\\u0637\\u0627\\u0642\\u062a\\u0643 \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0642\\u0644\\u064a\\u062f\\u064a\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0628\\u0634\\u0643\\u0644 \\u0622\\u0645\\u0646"}},"id":"643eb8a0bb232"}}}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => '2023-11-06 12:15:36'),
            array('key' => 'service-section','value' => '{"language":{"en":{"heading":"Service Provide","sub_heading":"Our Upheld Administrations What We Serve To You"},"es":{"heading":"Servicio proporciona","sub_heading":"Nuestras administraciones respaldadas Lo que le servimos"},"ar":{"heading":"\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629","sub_heading":"\\u0625\\u062f\\u0627\\u0631\\u0627\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0645\\u0639\\u062a\\u0645\\u062f\\u0629 \\u0645\\u0627 \\u0646\\u062e\\u062f\\u0645\\u0647 \\u0644\\u0643"}},"items":{"6436efd57d87f":{"language":{"en":{"title":"Virtual Credit Card Creation","sub_title":"Secure and convenient virtual credit card generation for online transactions, ensuring your financial data remains protected."},"es":{"title":"Creaci\\u00f3n de tarjetas de cr\\u00e9dito virtuales","sub_title":"Generaci\\u00f3n segura y conveniente de tarjetas de cr\\u00e9dito virtuales para transacciones en l\\u00ednea, lo que garantiza que sus datos financieros permanezcan protegidos."},"ar":{"title":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629","sub_title":"\\u0625\\u0646\\u0634\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0626\\u062a\\u0645\\u0627\\u0646 \\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u0645\\u0631\\u064a\\u062d\\u0629 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0628\\u0642\\u0627\\u0621 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0645\\u062d\\u0645\\u064a\\u0629."}},"id":"6436efd57d87f","image":"346b95cb-e7fe-431f-be49-6ca01c362dee.webp"},"6436efff890e3":{"language":{"en":{"title":"Entrepreneurial Partner Program","sub_title":"Opportunities for entrepreneurs to expand their revenue streams by offering virtual credit card services to clients."},"es":{"title":"Programa de Socios Emprendedores","sub_title":"Oportunidades para que los empresarios ampl\\u00eden sus fuentes de ingresos ofreciendo servicios de tarjetas de cr\\u00e9dito virtuales a los clientes."},"ar":{"title":"\\u0628\\u0631\\u0646\\u0627\\u0645\\u062c \\u0634\\u0631\\u0643\\u0627\\u0621 \\u0631\\u064a\\u0627\\u062f\\u0629 \\u0627\\u0644\\u0623\\u0639\\u0645\\u0627\\u0644","sub_title":"\\u0641\\u0631\\u0635 \\u0644\\u0631\\u0648\\u0627\\u062f \\u0627\\u0644\\u0623\\u0639\\u0645\\u0627\\u0644 \\u0644\\u062a\\u0648\\u0633\\u064a\\u0639 \\u0645\\u0635\\u0627\\u062f\\u0631 \\u0625\\u064a\\u0631\\u0627\\u062f\\u0627\\u062a\\u0647\\u0645 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0641\\u062a\\u0631\\u0627\\u0636\\u064a\\u0629 \\u0644\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621."}},"id":"6436efff890e3","image":"e8155f74-e5d6-41eb-b880-bc3d2bf8f2e2.webp"},"6436f026bdfe0":{"language":{"en":{"title":"User-Friendly Interface","sub_title":"An intuitive and easy-to-navigate platform designed for both beginners and experienced users, making online transactions a breeze."},"es":{"title":"Interfaz amigable","sub_title":"Una plataforma intuitiva y f\\u00e1cil de navegar dise\\u00f1ada tanto para principiantes como para usuarios experimentados, que facilita las transacciones en l\\u00ednea."},"ar":{"title":"\\u0648\\u0627\\u062c\\u0647\\u0629 \\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645","sub_title":"\\u0645\\u0646\\u0635\\u0629 \\u0628\\u062f\\u064a\\u0647\\u064a\\u0629 \\u0648\\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u062a\\u0646\\u0642\\u0644 \\u0645\\u0635\\u0645\\u0645\\u0629 \\u0644\\u0643\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0628\\u062a\\u062f\\u0626\\u064a\\u0646 \\u0648\\u0630\\u0648\\u064a \\u0627\\u0644\\u062e\\u0628\\u0631\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u062c\\u0639\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0623\\u0645\\u0631\\u064b\\u0627 \\u0633\\u0647\\u0644\\u0627\\u064b."}},"id":"6436f026bdfe0","image":"f7676f50-3cc0-4340-99b4-b1cf27f3ab0d.webp"},"6436f04798830":{"language":{"en":{"title":"Financial Inclusion","sub_title":"Access to secure online transactions for everyone, promoting financial inclusion and accessibility."},"es":{"title":"Inclusi\\u00f3n financiera","sub_title":"Acceso a transacciones en l\\u00ednea seguras para todos, promoviendo la inclusi\\u00f3n financiera y la accesibilidad."},"ar":{"title":"\\u0627\\u0644\\u0634\\u0645\\u0648\\u0644 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a","sub_title":"\\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0644\\u0644\\u062c\\u0645\\u064a\\u0639\\u060c \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u0634\\u0645\\u0648\\u0644 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a \\u0648\\u0625\\u0645\\u0643\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644."}},"id":"6436f04798830","image":"038289d5-72ba-43f4-90a7-db86bf8b38f7.webp"},"6436f066141b7":{"language":{"en":{"title":"Cutting-Edge Security","sub_title":"State-of-the-art encryption and security measures to safeguard your data and ensure the highest levels of protection."},"es":{"title":"Seguridad de vanguardia","sub_title":"Cifrado de \\u00faltima generaci\\u00f3n y medidas de seguridad para salvaguardar sus datos y garantizar los m\\u00e1s altos niveles de protecci\\u00f3n."},"ar":{"title":"\\u0627\\u0644\\u0623\\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0637\\u0648\\u0631","sub_title":"\\u0623\\u062d\\u062f\\u062b \\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u062a\\u0634\\u0641\\u064a\\u0631 \\u0648\\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 \\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0648\\u0636\\u0645\\u0627\\u0646 \\u0623\\u0639\\u0644\\u0649 \\u0645\\u0633\\u062a\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u062d\\u0645\\u0627\\u064a\\u0629."}},"id":"6436f066141b7","image":"0fbdbbb9-3db8-467c-a26c-613753bc8d41.webp"},"6436f088085ab":{"language":{"en":{"title":"Transparent Fee Structure","sub_title":"A straightforward fee system that ensures you always know what to expect, with no hidden costs."},"es":{"title":"Estructura de tarifas transparente","sub_title":"Un sistema de tarifas sencillo que garantiza que siempre sepa qu\\u00e9 esperar, sin costos ocultos."},"ar":{"title":"\\u0647\\u064a\\u0643\\u0644 \\u0631\\u0633\\u0648\\u0645 \\u0634\\u0641\\u0627\\u0641","sub_title":"\\u0646\\u0638\\u0627\\u0645 \\u0631\\u0633\\u0648\\u0645 \\u0645\\u0628\\u0627\\u0634\\u0631 \\u064a\\u0636\\u0645\\u0646 \\u0644\\u0643 \\u062f\\u0627\\u0626\\u0645\\u064b\\u0627 \\u0645\\u0639\\u0631\\u0641\\u0629 \\u0645\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u062a\\u0648\\u0642\\u0639\\u0647\\u060c \\u062f\\u0648\\u0646 \\u0623\\u064a \\u062a\\u0643\\u0627\\u0644\\u064a\\u0641 \\u0645\\u062e\\u0641\\u064a\\u0629."}},"id":"6436f088085ab","image":"9444c076-2eeb-460f-bfdd-0c6318439289.webp"},"6436f0a8c8891":{"language":{"en":{"title":"Constant Innovation","sub_title":"Continuous evolution to meet the ever-changing needs of the digital age, offering innovative solutions for seamless transactions."},"es":{"title":"Innovaci\\u00f3n constante","sub_title":"Evoluci\\u00f3n continua para satisfacer las necesidades siempre cambiantes de la era digital, ofreciendo soluciones innovadoras para transacciones fluidas."},"ar":{"title":"\\u0627\\u0644\\u0627\\u0628\\u062a\\u0643\\u0627\\u0631 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0645\\u0631","sub_title":"\\u0627\\u0644\\u062a\\u0637\\u0648\\u0631 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0645\\u0631 \\u0644\\u062a\\u0644\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u063a\\u064a\\u0631\\u0629 \\u0644\\u0644\\u0639\\u0635\\u0631 \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a\\u060c \\u0648\\u062a\\u0642\\u062f\\u064a\\u0645 \\u062d\\u0644\\u0648\\u0644 \\u0645\\u0628\\u062a\\u0643\\u0631\\u0629 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u0633\\u0644\\u0633\\u0629."}},"id":"6436f0a8c8891","image":"bc45f214-87ec-4bf6-8f5e-f72f30d3fcfd.webp"},"6436f148267e7":{"language":{"en":{"title":"24\\/7 Customer Support","sub_title":"Round-the-clock assistance from our dedicated support team to address your inquiries and provide help when you need it"},"es":{"title":"Atenci\\u00f3n al cliente 24 horas al d\\u00eda, 7 d\\u00edas a la semana","sub_title":"Asistencia las 24 horas del d\\u00eda por parte de nuestro equipo de soporte dedicado para atender sus consultas y brindarle ayuda cuando la necesite"},"ar":{"title":"\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0639\\u0644\\u0649 \\u0645\\u062f\\u0627\\u0631 24 \\u0633\\u0627\\u0639\\u0629 \\u0637\\u0648\\u0627\\u0644 \\u0623\\u064a\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0628\\u0648\\u0639","sub_title":"\\u0645\\u0633\\u0627\\u0639\\u062f\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0633\\u0627\\u0639\\u0629 \\u0645\\u0646 \\u0641\\u0631\\u064a\\u0642 \\u0627\\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0645\\u062e\\u0635\\u0635 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0644\\u0644\\u0631\\u062f \\u0639\\u0644\\u0649 \\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a\\u0643 \\u0648\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u0645\\u0633\\u0627\\u0639\\u062f\\u0629 \\u0639\\u0646\\u062f\\u0645\\u0627 \\u062a\\u062d\\u062a\\u0627\\u062c \\u0625\\u0644\\u064a\\u0647\\u0627"}},"id":"6436f148267e7","image":"4582508c-2041-4829-b970-551aa019c508.webp"}}}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => '2023-11-06 12:23:29'),
            array('key' => 'start-section','value' => '{"images":{"image":"81cf6f08-4def-4bf5-b1dc-327817e4f804.webp"},"language":{"en":{"heading":"Ready To Join StripeCard?","button_name":"Start Now","button_link":"contact"},"es":{"heading":"\\u00bfListo para unirte a StripeCard?","button_name":"Empezar ahora","button_link":"contact"},"ar":{"heading":"\\u0647\\u0644 \\u0623\\u0646\\u062a \\u0645\\u0633\\u062a\\u0639\\u062f \\u0644\\u0644\\u0627\\u0646\\u0636\\u0645\\u0627\\u0645 \\u0625\\u0644\\u0649 StripeCard\\u061f","button_name":"\\u0627\\u0628\\u062f\\u0623 \\u0627\\u0644\\u0622\\u0646","button_link":"contact"}}}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => '2023-11-06 12:28:45'),
            array('key' => 'blog-section','value' => '{"language":{"en":{"title":"Announcement","heading":"Our Recent Announcement"},"es":{"title":"Anuncio","heading":"Nuestro anuncio reciente"},"ar":{"title":"\\u0625\\u0639\\u0644\\u0627\\u0646","heading":"\\u0625\\u0639\\u0644\\u0627\\u0646\\u0646\\u0627 \\u0627\\u0644\\u0623\\u062e\\u064a\\u0631"}}}','status' => '1','serialize' => NULL,'created_at' => NULL,'updated_at' => '2023-11-06 15:08:07'),
            array('key' => 'statistics-section','value' => '{"language":{"en":{"total_users":"100","happy_users":"1000","total_service":"12000"},"es":{"total_users":"100","happy_users":"80","total_service":"100"},"ar":{"total_users":"100","happy_users":"1000","total_service":"12000"}}}','status' => '1','serialize' => NULL,'created_at' => '2023-09-05 11:56:04','updated_at' => '2023-11-06 12:19:09')
        );



        SiteSections::insert($site_sections);


    }
}
